/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon;

import com.quantumdata.busmon.ConnectDialog;
import com.quantumdata.busmon.FindDialog;
import com.quantumdata.busmon.MainAppFrame;
import com.quantumdata.busmon.SendCommandDialog;
import com.quantumdata.busmon.Sniffer;
import com.quantumdata.busmon.parser.BadPacketException;
import com.quantumdata.busmon.parser.CECDataBlock;
import com.quantumdata.busmon.parser.DisplayPort.DisplayPortDataBlock;
import com.quantumdata.busmon.parser.DisplayPort.DisplayPortPacketTrace;
import com.quantumdata.busmon.parser.HDMIPacketTrace;
import com.quantumdata.busmon.parser.I2CDataBlock;
import com.quantumdata.busmon.parser.I2CMessage;
import com.quantumdata.busmon.parser.PacketTrace;
import com.quantumdata.busmon.parser.PacketTraceType;
import com.quantumdata.busmon.parser.Parser;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

class CommandAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private Command aCommand;

    CommandAction(String string, Command command) {
        super(string);
        this.aCommand = command;
    }

    CommandAction(String string, Command command, KeyStroke keyStroke, int n) {
        this(string, command);
        if (keyStroke != null) {
            this.putValue("AcceleratorKey", keyStroke);
        }
        if (n != 0) {
            this.putValue("MnemonicKey", n);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        switch (this.aCommand) {
            case CONNECT: {
                ConnectDialog connectDialog = new ConnectDialog((Frame)Sniffer.window, true);
                connectDialog.setVisible(true);
                break;
            }
            case NEW: {
                if (MainAppFrame.confirmNewAction.isTrue() && Parser.packets.needsSaving()) break;
                if (Parser.packets != null) {
                    Parser.packets.clear();
                }
                I2CDataBlock.resetParser();
                CECDataBlock.resetParser();
                DisplayPortDataBlock.resetParser();
                MainAppFrame.openFile = null;
                Sniffer.window.updateTitleBarText();
                MainAppFrame.saveAction.setEnabled(false);
                I2CMessage.resetEDID();
                break;
            }
            case OPEN: {
                PacketTrace packetTrace;
                PacketTraceType packetTraceType = PacketTraceType.HDMI_PACKET_TRACE_TYPE;
                if (MainAppFrame.confirmNewAction.isTrue() && Parser.packets.needsSaving()) {
                    return;
                }
                File file = MainAppFrame.ShowOpenFileDialog("Open Trace File", "Open", "Read A Trace From A Saved File");
                if (file == null) break;
                ObjectInputStream objectInputStream = null;
                try {
                    I2CMessage.resetEDID();
                    objectInputStream = new ObjectInputStream(new FileInputStream(file));
                    packetTraceType = PacketTrace.getTraceType(objectInputStream);
                    objectInputStream.close();
                    objectInputStream = new ObjectInputStream(new FileInputStream(file));
                    packetTrace = packetTraceType == PacketTraceType.DISPLAYPORT_PACKET_TRACE_TYPE ? new DisplayPortPacketTrace(objectInputStream) : new HDMIPacketTrace(objectInputStream);
                    objectInputStream.close();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    JOptionPane.showMessageDialog(Sniffer.window, "This file does not appear to be a trace file, is from an older version of the application, or is corrupted.");
                    break;
                }
                catch (BadPacketException badPacketException) {
                    JOptionPane.showMessageDialog(Sniffer.window, "Error Reading Packet Trace File\n" + badPacketException.getMessage());
                    break;
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(Sniffer.window, "There was an I/O error while attempting to read the trace file: " + iOException.getMessage());
                    break;
                }
                MainAppFrame.openFile = file;
                Parser.packets = packetTrace;
                Sniffer.window.setUpPacketTable();
                Sniffer.window.updateToolBar();
                MainAppFrame.saveAction.setEnabled(true);
                Sniffer.window.updateTitleBarText();
                Sniffer.window.setTraceToBeginning();
                break;
            }
            case SAVE: {
                this.save();
                break;
            }
            case QUIT: {
                if (MainAppFrame.confirmExitAction.isTrue() && Parser.packets.needsSaving()) {
                    MainAppFrame.saveAsAction.save();
                }
                System.exit(0);
                break;
            }
            case FIND: {
                if (MainAppFrame.findDialog == null) {
                    MainAppFrame.findDialog = new FindDialog((Frame)Sniffer.window, false);
                }
                MainAppFrame.findDialog.setVisible(true);
                break;
            }
            case FINDNEXT: {
                if (MainAppFrame.findDialog == null) {
                    MainAppFrame.findDialog = new FindDialog((Frame)Sniffer.window, false);
                    MainAppFrame.findDialog.setVisible(true);
                    break;
                }
                ((FindDialog)MainAppFrame.findDialog).findNext();
                break;
            }
            case SENDCOMMAND: {
                if (MainAppFrame.sendCommandDialog == null) {
                    MainAppFrame.sendCommandDialog = new SendCommandDialog((Frame)Sniffer.window, false);
                }
                MainAppFrame.sendCommandDialog.setVisible(true);
                break;
            }
            case COLORS: {
                break;
            }
            case ABOUT: {
                String string = String.format("Quantum Data Auxiliary Channel Analyzer\nVersion %d.%d (Trace File Format Version %d.%d)\n\nCopyright (c) 2006-2008 by Quantum Data.  All rights reserved.", 1, 41, 2, 8);
                JOptionPane.showMessageDialog(Sniffer.window, string);
                break;
            }
        }
    }

    public void save() {
        File file = MainAppFrame.ShowSaveFileDialog("Save Data", "Save", "Save Data");
        if (file != null) {
            String string;
            int n;
            boolean bl = true;
            if (file.exists() && (n = JOptionPane.showConfirmDialog(Sniffer.window, string = file.getName() + " exists.  Overwrite?", "Confirm Save", 0, 2)) == 1) {
                bl = false;
            }
            if (bl) {
                string = file.getName();
                if (string.endsWith(".html")) {
                    Sniffer.window.saveToHTML(file);
                } else if (string.endsWith(".txt")) {
                    Sniffer.window.saveToText(file);
                } else if (string.endsWith(".xml")) {
                    I2CMessage.writeXMLEDID(file);
                } else if (string.endsWith(".BMtrace")) {
                    ObjectOutputStream objectOutputStream = null;
                    try {
                        objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                        Parser.packets.writeTrace(objectOutputStream);
                        objectOutputStream.close();
                        MainAppFrame.openFile = file;
                        Sniffer.window.updateTitleBarText();
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(Sniffer.window, "There was an I/O error while attempting to save the trace: " + iOException.getMessage());
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Command {
        CONNECT,
        NEW,
        OPEN,
        SAVEAS,
        QUIT,
        FIND,
        FINDNEXT,
        SENDCOMMAND,
        ABOUT,
        COLORS,
        SAVETOHTML,
        SAVEEDIDFROMTRACE,
        SAVE,
        SAVETOTEXT;

    }
}

